package book.beans;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.RequestScoped;
import javax.faces.component.html.HtmlDataTable;
import javax.inject.Named;

/**
 *
 * @author Leonard
 */
@Named
@RequestScoped
public class PlayersBean {

    private final static Logger logger =
            Logger.getLogger(PlayersBean.class.getName());
    private HtmlDataTable table;
    ArrayList<Players> dataArrayList = new ArrayList<>();
    final SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy");

    public PlayersBean() {
        try {
            dataArrayList.add(new Players(2, "NOVAK DJOKOVIC", (byte) 26, "Belgrade, Serbia", "Monte Carlo, Monako", (short) 188, (byte) 80, "Boris Becker, Marian Vajda", sdf.parse("22.05.1987")));
            dataArrayList.add(new Players(1, "RAFAEL NADAL", (byte) 27, "Manacor, Majorka, Hiszpania", "Manacor, Mallorca, Hiszpania", (short) 185, (byte) 85, "Toni Nadal", sdf.parse("03.06.1986")));
            dataArrayList.add(new Players(7, "TOMAS BERDYCH", (byte) 28, "Valasske Mezirici, Czechy", "Monte Carlo, Monako", (short) 196, (byte) 91, "Tomas Krupa", sdf.parse("17.09.1985")));
            dataArrayList.add(new Players(8, "STANISLAS WAWRINKA", (byte) 28, "Lozanna, Szwajcaria", "St. Barthelemy, Szwajcaria", (short) 183, (byte) 81, "Magnus Norman", sdf.parse("28.03.1985")));
            dataArrayList.add(new Players(4, "ANDY MURRAY", (byte) 26, "Dunblane, Szkocja", "Londyn, Anglia", (short) 190, (byte) 84, "Ivan Lendl", sdf.parse("15.05.1987")));
            dataArrayList.add(new Players(5, "JUAN MARTIN DEL POTRO", (byte) 25, "Tandil, Argentyna", "Tandil, Argentyna", (short) 198, (byte) 97, "Franco Davin", sdf.parse("23.09.1988")));
            dataArrayList.add(new Players(10, "JO-WILFRIED TSONGA", (byte) 28, "Le Mans, Francja", "Gingins, Szwajcaria", (short) 188, (byte) 91, "Nicolas Escude oraz Thierry Ascione", sdf.parse("17.04.1985")));
            dataArrayList.add(new Players(6, "ROGER FEDERER", (byte) 32, "Bazylea, Szwajcaria", "Bottmingen, Szwajcaria", (short) 185, (byte) 85, "Stefan Edberg, Severin Luthi", sdf.parse("08.08.1981")));
            dataArrayList.add(new Players(9, "RICHARD GASQUET", (byte) 27, "Beziers, Francja", "Neuchatel, Szwajcaria", (short) 185, (byte) 75, "Sergi Bruguera oraz Sebastien", sdf.parse("18.06.1986")));
            dataArrayList.add(new Players(3, "DAVID FERRER", (byte) 31, "Javea, Hiszpania", "Walencja, Hiszpania", (short) 175, (byte) 73, "Jose Francisco Altur", sdf.parse("02.04.1982")));

        } catch (ParseException ex) {
            Logger.getLogger(PlayersBean.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public ArrayList<Players> getDataArrayList() {
        return dataArrayList;
    }

    public void setDataArrayList(ArrayList<Players> dataArrayList) {
        this.dataArrayList = dataArrayList;
    }

    public HtmlDataTable getTable() {
        return table;
    }

    public void setTable(HtmlDataTable table) {
        this.table = table;
    }

    public void tableAction() {
        logger.log(Level.INFO, "Pierwszy wiersz:{0}", table.getFirst());
        logger.log(Level.INFO, "Liczba wierszy: {0}", table.getRowCount());
        table.setRows(3);
    }
}